// Exp-20 : Design the following IIR filters with the given specification.
//           (1) Butter Worth  (2) Chebyshev-I  (3) Chebyshev-II  (4) Elliptical 

////////////////////////////////////////////////////////////////////////
//    Example:
//                 filter type ('lp','hp','sb','bp')
//                 design approximation ('butt','cheb1','cheb2','ellip')
//                 om=[om1,om2,om3,om4], 0 <= om1 <= om2 <= om3 <= om4 <= pi .When ftype='lp' or 'hp', om3 and om4 are not used and may be set to 0.
//                 0<= deltap <=1
//                 0<= deltas <=1
///////////////////////////////////////////////////////////////////////////

//Evaluate magnitude response of the filter

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
close;
clear;
//ftype=input('Enter the Filter Type:','s');
//approx=input('Enter the Filter Name:','s');
//om=input('Enter Cut-Off Frequency Vector:');
//deltap=input('Enter Ripple in the Passband:');
//deltas=input('Enter ripple in the Stopband:');


ftype='lp';
approx='cheb2';
om=[0.3 0.5];
deltap=0.1;
deltas=0.4;


[cells,fact,zzeros,zpoles]=eqiir(ftype,approx,om,deltap,deltas);
h=fact*poly(zzeros,'z')/poly(zpoles,'z');

pole_real=[];
pole_imag=[];
for i=1:length(zpoles)
    pole_real=[pole_real real(zpoles(i))];
    pole_imag=[pole_imag imag(zpoles(i))];
end


mtlb_axis([-1 1 -1 1]);
xgrid();
plot(pole_real,pole_imag,'cya+','marker','d','markerfac','red','markeredg','red');

title('Pole Location','color','red','fontsize', 4);
xlabel("Real Axis", "fontsize", 2,"color", "blue");
ylabel("Imaginary Axis", "fontsize", 2, "color", "blue");


